@extends('layouts.master')
@section('title', __('Gst Setting'))
@section('breadcum')
<div class="breadcrumbbar">
  <h4 class="page-title">{{ __('Gst Settings') }}</h4>
  <div class="breadcrumb-list">
    <ol class="breadcrumb">
      <li class="breadcrumb-item"><a href="{{url('/admin')}}" title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a>
      </li>
      <li class="breadcrumb-item active" aria-current="page">{{ __('Gst Settings') }}</li>
    </ol>
  </div>
</div>
@endsection
@section('maincontent')
<div class="contentbar">\
  <div class="row">
    <div class="col-lg-12">
      <div class="card m-b-30">
        <div class="card-header">
          <h5 class="box-title">{{ __('Gst Settings') }}</h5>
        </div>
        <div class="card-body ml-2">
            <form method="POST" action="{{ route('gst.update') }}">
                @csrf
                <div class="row">
                    <div class="col-lg-2 col-md-3 col-4">
                        <div class="form-group mb-3">
                            <label for="customSwitch" class="text-dark">{{ __('Enable Gst') }}</label>
                            <div class="form-switch mt-1">
                                {{-- Hidden input ensures 0 is submitted if checkbox is unchecked --}}
                                <input type="hidden" name="gst_enable" value="0">
                        
                                <input class="custom_toggle form-check-input" 
                                       type="checkbox" 
                                       name="gst_enable" 
                                       id="customSwitch"
                                       value="1" 
                                       {{ old('gst_enable', $data?->gst_enable) == '1' ? 'checked' : '' }} />
                            </div>
                        </div>
                        
                    </div>
                    <div class="col-lg-10 col-md-9 col-8" id="additionalInputBox"
                        style="{{ $data?->gst_enable == '1' ? '' : 'display:none' }}">
                        <div class="row">
                            <div class="col-lg-3">
                                <div class="form-group mb-3">
                                    <label for="gstnumber" class="text-dark">{{ __('Gst Number') }}
                                        <span class="text-danger align-middle">*</span>
                                    </label>
                                    <input type="number" name="gst_number" value="{{ $data?->gst_number ?? '' }}" placeholder="Enter Gst Number"
                                        id="gstnumber" class="form-control">
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="form-group mb-3">
                                    <label for="companyname" class="text-dark">{{ __('Company Name') }}
                                        <span class="text-danger align-middle">*</span>
                                    </label>
                                    <input type="text" name="company_name" value="{{ $data?->company_name ?? '' }}" placeholder="Enter Company Name"
                                        id="companyname" class="form-control">
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="form-group mb-3">
                                    <label for="address" class="text-dark">{{ __('Full address') }}
                                        <span class="text-danger align-middle">*</span>
                                    </label>
                                    <input type="text" name="address" value="{{ $data?->address ?? '' }}" placeholder="Enter Address"
                                        id="address" class="form-control">
                                </div>
                            </div>
                            <div class="col-lg-3">
                                <div class="form-group mb-3">
                                    <label for="per" class="text-dark">{{ __('GST Percentage') }}
                                        <span class="text-danger align-middle">*</span>
                                    </label>
                                    <span class="gst-percent"><input type="number" name="gst_per" value="{{ $data?->gst_per ?? '' }}" placeholder="Enter Gst Percentage"
                                        id="per" class="form-control"><div class="icon">%</div></span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-12">
                        <div class="form-group table-btn mt-4">
                            <button type="reset" class="btn btn-secondary" title="{{ __('Reset') }}">
                                <i class="flaticon-ban-circle-symbol"></i>{{ __('Reset') }}
                            </button>
                            <button type="submit" class="btn btn-primary" title="{{ __('Update') }}">
                                <i class="flaticon-check-mark"></i>{{ __('Update') }}
                            </button>
                        </div>
                    </div>
                </div>
            </form>
            
        </div>
      </div>
    </div>
  </div>
</div>
@endsection
@section('script')
<script>
function toggleInputBoxes() {
    var checkbox = document.getElementById('customSwitch');
    var additionalInputBox = document.getElementById('additionalInputBox');
    additionalInputBox.style.display = checkbox.checked ? '' : 'none';
}
document.getElementById('customSwitch').addEventListener('change', toggleInputBoxes);
toggleInputBoxes();
</script>
@endsection